// JavaScript pour la page d'avis

document.addEventListener("DOMContentLoaded", () => {
  initRatingSystem()
  initAvisForm()
})

function initRatingSystem() {
  const stars = document.querySelectorAll(".star")
  const ratingInput = document.getElementById("rating")

  stars.forEach((star, index) => {
    star.addEventListener("click", () => {
      const rating = index + 1
      setRating(rating)
      ratingInput.value = rating
    })

    star.addEventListener("mouseenter", () => {
      highlightStars(index + 1)
    })
  })

  document.querySelector(".rating-group").addEventListener("mouseleave", () => {
    const currentRating = Number.parseInt(ratingInput.value) || 0
    setRating(currentRating)
  })
}

function setRating(rating) {
  const stars = document.querySelectorAll(".star")

  stars.forEach((star, index) => {
    if (index < rating) {
      star.textContent = "★"
      star.classList.add("active")
    } else {
      star.textContent = "☆"
      star.classList.remove("active")
    }
  })
}

function highlightStars(rating) {
  const stars = document.querySelectorAll(".star")

  stars.forEach((star, index) => {
    if (index < rating) {
      star.textContent = "★"
      star.style.color = "#FFD700"
    } else {
      star.textContent = "☆"
      star.style.color = "#7a7a7a"
    }
  })
}

function initAvisForm() {
  const form = document.querySelector(".avis-form")

  if (form) {
    form.addEventListener("submit", (e) => {
      if (!validateAvisForm()) {
        e.preventDefault()
      }
    })
  }
}

function validateAvisForm() {
  const rating = document.getElementById("rating").value
  const comment = document.querySelector('textarea[name="comment"]').value

  if (!rating || rating < 1 || rating > 5) {
    showNotification("Veuillez sélectionner une note", "error")
    return false
  }

  if (!comment.trim()) {
    showNotification("Veuillez écrire un commentaire", "error")
    return false
  }

  if (comment.trim().length < 10) {
    showNotification("Le commentaire doit contenir au moins 10 caractères", "error")
    return false
  }

  return true
}

function showNotification(message, type) {
  // Créer la div de notification
  const notificationDiv = document.createElement("div")
  notificationDiv.classList.add("notification", type)
  notificationDiv.textContent = message

  // Ajouter la notification au body
  document.body.appendChild(notificationDiv)

  // Faire disparaître la notification après quelques secondes
  setTimeout(() => {
    notificationDiv.remove()
  }, 3000) // 3 secondes
}
